#!/bin/sh

if [ ! -e /bin/vim-cmd ]; then
	VIMCMD="/usr/bin/vim-cmd";
else
	VIMCMD="/bin/vim-cmd";
fi

if [ "${#}" != 4 ]; then
    printf "Usage:\n\t`basename ${0}` [vmdk_full_path] [prefix_name] [start_num] [end_num]\n";
    echo "e.g.:";
    printf "\t${0} /vmfs/volumes/datastore1/sandbox/sandbox.vmx clone_sandbox_ 1 6\n";
    exit 1
fi

full_clone () {

    local src_vmdk="$(echo ${1} | sed 's/\.vmx$/\.vmdk/g')";
    local dst_prefix=${2};
    local start_num=${3};
    local end_num=${4};

    local datastore1=${src_vmdk%/*/*};
    local src_prefix=$(basename ${src_vmdk} | sed 's/\.vmdk$//g');
    local src_vmx="${datastore1}/${src_prefix}/${src_prefix}.vmx"

    for num in $(seq ${start_num} ${end_num}); do

        clonedpath="${datastore1}/${dst_prefix}${num}";
        dst_vmdk="${clonedpath}/${dst_prefix}${num}.vmdk";
        dst_vmx="${clonedpath}/${dst_prefix}${num}.vmx";

        /bin/mkdir "${clonedpath}";
        vmkfstools -d thin -i "${src_vmdk}" "${dst_vmdk}";
        sleep 3;
        /bin/cp ${src_vmx} ${dst_vmx};
        /bin/cat ${dst_vmx} | grep -v "ethernet0.generatedAddress = " \
            | grep -v "ethernet0.generatedAddressOffset = " \
            | grep -v "uuid.location = " \
            | grep -v "uuid.bios = " \
            | sed 's/'${src_prefix}'/'${dst_prefix}${num}'/g' > vmx.tmp

        /bin/cp vmx.tmp ${dst_vmx};
		/bin/rm -f vmx.tmp
		sed -i 's/^displayName = .*$/displayName = \"'${dst_prefix}${num}'\"/' ${dst_vmx}
        sleep 2;
        ${VIMCMD} solo/registervm ${dst_vmx};
        sleep 1;

        # drop a file to indicate the cloned vm is cloned by DDA
        [ ! -e "${clonedpath}/CLONED" ] && touch "${clonedpath}/CLONED"
    done

}

full_clone ${1} ${2} ${3} ${4}
exit 0

